<?php
use application\models\hclinica\TestModel;

//use application\models\hclinica\CitaModel;
//use application\models\hclinica\CitaModel;
//use application\models\hclinica\models\CitaModel;

//namespace application\controllers\clinica;

class CitaC extends CI_Controller
{
    public $conexion;
    //public $CitaModel;
    
    public function __construct()
    {
        //new CitaModel()
        parent::__construct();
        $this->load->helper("url");
        $this->load->helper("form");
        $this->load->library('Form_validation');
        $this->load->library("parser");
        $this->load->library("session");
        
        $this->conexion=$this->load->database("hclinica",true);
        //$this->load->model("hclinica/models/CitaModel");
        //$this->CitaModel=$this->CitaModel->model();
        //CI_Controller::get_instance();
        //$this->citaModel=new CitaModel();
        $this->load->model("hclinica/CitaModel","citaModel");
        
        $this->testModel=new TestModel();
    }
    public function index()
    {
        $this->citaModel->guardar("objeto",1);
    }
    public function formCita($id=null)
    {
        $data=$this->init();
        if($id!=null)
        {
            $data=$this->citaModel->getCitaById($id);
            $time=strtotime($data["fechaAtencion"]);
            $data["minuto"]=date("i",$time);
            if($data==null){
                show_404();
            }
            //$time=strtotime($data["fechaAtencion"]);
            $data["fecha"]=date("d-m-Y",$time);
            $data["hora"]=date("H",$time);
        }
        $this->load->view("hclinica/form/cita/formCita",$data);
    }
    public function listCita()
    {
        $this->load->view("hclinica/lista/cita/listCita");
    }
    public function guardarCita()
    {
        $res=array("res"=>false,"message"=>"Error al guardar");
        if($this->input->server("REQUEST_METHOD")=="POST"){
            $data=array(
                "fechaAtencion"=>date("Y-m-d",strtotime($this->input->post("fecha")))." ".$this->input->post("hora").":".$this->input->post("minuto").":00",
                "idCita"=>$this->input->post("idCita"),
                "fechaAlta"=>date("Y-m-d H:i:s"),
                "idPaciente"=>1,
                "asunto"=>$this->input->post("asunto"),
                "comentarios"=>$this->input->post("comentarios"),
                "situacion"=>"PENDIENTE",
                "status"=>1
            );
            $this->citaModel->guardarArray($data,"idCita");
            $res["res"]=true;
            $res["message"]="Cambios guardados";
        }
        echo json_encode($res);
    }
    public function getAllCitas()
    {
        $res=array("res"=>false,"message"=>"","citas"=>array());
        
        if($this->input->is_ajax_request())
        {
            $this->conexion->select('*');
            $this->conexion->from('cita');
            $query = $this->conexion->get();
            $row = $query->result_array();
            $res["citas"]=$row;
            $res["res"]=true;
        }
        echo json_encode($res);
    }
    public function cancelarCita()
    {
        $res=array("res"=>false,"message"=>"Error al guardar cita");
        
        if($this->input->server("REQUEST_METHOD")=="POST"){
            $cita=$this->citaModel->getCitaById($this->input->post("idCita"));
            
            if($cita!=null){
                $cita["situacion"]="CANCELADO";
                $this->citaModel->guardarCita($cita);
                $res["res"]=true;
                $res["message"]="Cambios guardados";
            }
        }
        echo json_encode($res);
    }
    public function calendarioCitas()
    {
        $data["eventos"]=$this->getEventosCitas();
        $this->load->view("hclinica/lista/cita/calendarioCitas",$data);
    }
    public function getEventosCitas()
    {
        $res=array();
        $stmt=$this->conexion->query("SELECT * FROM cita WHERE status=?",[1]);
        $list=$stmt->result_array();
        $colores=$this->calendarColors();
        $length=count($colores);
        foreach ($list as $key=>$cita) {
            $fin= strtotime( '+120 minute' ,strtotime ($cita["fechaAtencion"]));
            $evento=array("title"=>trim($cita["asunto"]),
                "start"=>str_replace(" ", "T", $cita["fechaAtencion"]),
                "end"=>str_replace(" ", "T", date("Y-m-d H:i:s",$fin)),
                "url"=>"javascript:ver()"
            );
            $i=$key%($length);            
            //$res[]=$evento;
            $res[]=array_merge($evento,$colores[$i]);
        }
        /*$conexion=AgendaParams::getConexionConfigure();
        $citaDao=new CitaDao($conexion);
        
        $list=$citaDao->getListaCita();
        
        $colores=self::calendarColors();
        $length=count($colores);
        foreach ($list as $key=>$cita) {
            $fin= strtotime( '+120 minute' ,strtotime ($cita->getFechaAtencion()));
            $evento=array("title"=>trim($cita->getAsunto()),
                "start"=>str_replace(" ", "T", $cita->getFechaAtencion()),
                "end"=>str_replace(" ", "T", date("Y-m-d H:i:s",$fin)),
                "url"=>"javascript:ver()"
            );
            $i=$key%($length);            
            //$res[]=$evento;
            $res[]=array_merge($evento,$colores[$i]);
        }*/
        return $res;
    }
    public function calendarColors()
    {
        $colores=array();
        $red=array("backgroundColor"=>"#f56954","borderColor"=>"#f56954");
        $yellow=array("backgroundColor"=>"#f39c12","borderColor"=>"#f39c12");
        $blue=array("backgroundColor"=>"#0073b7","borderColor"=>"#0073b7");
        $info=array("backgroundColor"=>"#00c0ef","borderColor"=>"#00c0ef");
        $green=array("backgroundColor"=>"#00a65a","borderColor"=>"#00a65a");
        $lightblue=array("backgroundColor"=>"#3c8dbc","borderColor"=>"#3c8dbc");
        array_push($colores,$red,$yellow,$blue,$info,$green,$lightblue);
        return $colores;
    }
    private function init()
    {
        $data=array(
            "idCita"=>0,
            "idPaciente"=>0,
            "asunto"=>"",
            "comentarios"=>"",
            "fecha"=>date("d-m-Y"),
            "hora" => date("H"),
            "minuto" => date("i"),
            "fechaAlta"=>date("Y-m-d H:i:s"),
            "situacion"=>"PENDIENTE",
            "status"=>0
        );
        return $data;
    }
}

