<?php
defined('BASEPATH') OR exit('No direct script access allowed');
//namespace application\controllers\pacientes;

class AdeudoCuenta extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $helpers=array("url","form");
        $libraries=array("session","parser",'Form_validation',"encryption");
        $this->load->helper($helpers);
        $this->load->library($libraries);
        $this->encryption->initialize(array('driver' => "openssl"));
        
        $this->load->library("LibApp");
        $this->load->library("hclinica/itemPaciente",null,"itemPaciente");
        $this->load->helper("hclinica/tables_helper");
        
        $this->conexion=$this->load->database("hclinica",true);
        $this->load->model("hclinica/EncHistoriaModel","encHistoriaModel");
        $this->load->model("hclinica/CuentaModel","cuentaModel");
        $this->load->model("hclinica/MovCuentaModel","movCuentaModel");
        $this->load->model("hclinica/EncPagoModel","encPagoModel");
        $this->load->model("hclinica/PagoModel","pagoModel");
    }
    public function adeudoPaciente()
    {
        $data=[];
        $get=$this->input->get();
        //var_dump($get["id"]);
        //var_dump($this->encryption->decrypt($get["id"]));
        //$paciente=$this->pacienteModel->getPacienteById($this->encryption->decrypt($get["id"]));
        $itemPaciente=$this->itemPaciente->getItemPaciente($this->encryption->decrypt($get["id"]));
        if($itemPaciente!=null)
        {
            $data["itemPaciente"]=(array)$itemPaciente;
            $data["itemPaciente"]["clave"]=$this->encryption->encrypt($itemPaciente->idPaciente);
            $this->parser->parse("hclinica/form/paciente/formAdeudoPagoPaciente",$data);
        }
        else{
            show_404();
        }
    }
    public function getListAdeudoPaciente()
    {
        $res=array("res"=>false,"message"=>"Error al guardar datos");

        if($this->input->server("REQUEST_METHOD")=="POST")
        {
            $post=$this->input->post();
            $idPaciente=$this->encryption->decrypt($post["clave"]);
            //$list=$this->cuentaModel->getListAdeudoCuenta($this->encryption->decrypt($post["clave"]));
            $stmt=$this->conexion->query("select idCuenta, cuenta.idNotaVenta, serie, folio, monto, saldo, cuenta.fechaAlta from cuenta inner join notaventa on cuenta.idNotaVenta=notaventa.idNotaVenta WHERE cuenta.idPaciente=? AND saldo>? AND cuenta.situacion<>? AND cuenta.status=? AND notaventa.status=?",[$idPaciente,0,'CANCELADO',1,1]);
            $list=$stmt->result_array();

            foreach ($list as $key => $value) {
                $value["monto"]=floatval($value["monto"]);
                $value["saldo"]=floatval($value["saldo"]);
                $value["cIdCuenta"]=$this->encryption->encrypt($value["idCuenta"]);
                $value["cIdPaciente"]=$this->encryption->encrypt($idPaciente);
                $res["list"][]=$value;
            }
            //$res["list"]=$list;
            $res["res"]=true;
            $res["message"]="Datos consultados";
        }
        echo json_encode($res);
    }
    public function pagarNotas()
    {
        $res=array("res"=>false,"message"=>"Error al guardar datos");

        if($this->input->server("REQUEST_METHOD")=="POST")
        {
            $post=$this->input->post();
            $idCuenta=intval($this->encryption->decrypt($post["clave"]));
            $idPaciente=intval($this->encryption->decrypt($post["idPaciente"]));
            $cuentas=[$idCuenta]; //por ahora es cuenta por cuenta
            $listCuenta=$this->cuentaModel->getListCuentaByKeys($idCuenta);

            $encPago=instanciarEncPago();
            $encPago["idPaciente"]=$idPaciente;
            $encPago["serie"]="A".$this->libapp->getUsuarioSession()["idUsuario"];
            $encPago["idUsuario"]=$this->libapp->getUsuarioSession()["idUsuario"];
            $folio=$this->cuentaModel->getDato("SELECT IF(MAX(folio)>0,MAX(folio)+1,1) FROM encpago WHERE serie=?",[$encPago["serie"]]);
            $encPago["folio"]=$folio;
            $encPago["fecha"]=date("Y-m-d H:i:s");
            $encPago["monto"]=floatval($post["importe"]);
            $encPago["situacion"]="PAGADO";
            $encPago["tipo"]="CREDITO";
            $encPago["comentario"]=$post["comentario"];
            $encPago=(object)$encPago;

            $this->encPagoModel->guardarStdEncPago($encPago);

            if(!empty($listCuenta))
            {
                foreach ($listCuenta as $key => $cuenta) 
                {
                    $pago=instanciarPago();
                    $movCuenta=instanciarMovCuenta();

                    $movCuenta["saldoAnterior"]=$cuenta->saldo;
                    $pago["idEncPago"]=$encPago->idEncPago;

                    $monto=$encPago->monto;
                    if($monto>=$cuenta->saldo)
                    {
                        $pago["importe"]=$cuenta->saldo;
                        $monto-=$cuenta->saldo;
                        $cuenta->saldo=0;
                    }else{
                        if($monto>0){
                            $cuenta->saldo=$cuenta->saldo - $monto;
                            $pago["importe"]=$monto;
                            $monto=0;
                        }
                    }

                    $pago["idCuenta"]=$cuenta->idCuenta;
                    $pago["idNotaVenta"]=$cuenta->idNotaVenta;
                    $pago["situacion"]="PAGO";            
                    $pago=(object)$pago;        
                    $this->pagoModel->guardarStdPago($pago);

                    $movCuenta["fechaAlta"]=$encPago->fecha;
                    $movCuenta["idCuenta"]=$cuenta->idCuenta;
                    $movCuenta["idUsuario"]=$this->libapp->getUsuarioSession()["idUsuario"];
                    $movCuenta["importe"]=$pago->importe;
                    $movCuenta["motivo"]="ABONO DE NOTAS";
                    $movCuenta["saldoActual"]=$cuenta->saldo;
                    $movCuenta["situacion"]="VIGENTE";
                    $movCuenta["tipoMov"]="ABONO";
                    $movCuenta["idEncPago"]=$encPago->idEncPago;
                    $movCuenta["status"]=1;

                    $movCuenta=(object)$movCuenta;
                    $this->movCuentaModel->guardarStdMovCuenta($movCuenta);
                    $this->cuentaModel->guardarStdCuenta($cuenta);
                }
            }

            $res["post"]=$post;
            $res["res"]=true;
            $res["message"]="Datos consultados";
        }
        echo json_encode($res); 
    }
    function listPagoNotas()
    {
        $res=array("res"=>false,"message"=>"Error al consultar","datos"=>[]);

        if($this->input->server("REQUEST_METHOD")=="POST")
        {
            if($this->input->is_ajax_request())
            {
                $this->conexion->select('encpago.idPaciente,codigo,nombre,appat,apmat,serie,folio,monto,fecha');
                $this->conexion->from('persona');
                $this->conexion->join('paciente', 'paciente.idPersona=persona.idPersona', 'inner');
                $this->conexion->join("encpago","paciente.idPaciente=encpago.idPaciente","inner");
                $query = $this->conexion->get();
                $row = $query->result_array();
                foreach ($row as $key => $val) {
                    $var=$val;
                    $var["clavePaciente"]=$this->encryption->encrypt($val["idPaciente"]);
                    $var["nombreCompleto"]=$val["nombre"]." ".$val["appat"]." ".$val["apmat"];
                    $res["datos"][]=$var;
                }
                $res["res"]=true;
            }
        }
        echo json_encode($res);
    }
    function verHistorialNota()
    {
        $post=$this->input->post();
        $idCuenta=$this->encryption->decrypt($post["idCuenta"]);

        $this->conexion->select("*");
        $this->conexion->from("movcuenta");
        $this->conexion->where("idCuenta",$idCuenta);
        $query = $this->conexion->get();
        $row = $query->result_array();        

        $data=["folioNota"=>$post["folio"],"id"=>$idCuenta,"list"=>$row];
        $this->load->view("hclinica/lista/paciente/historialPagoNotaView",$data);
    }
}

