<?php
// namespace application\libraries\general;
defined('BASEPATH') OR exit('No direct script access allowed');

class DatabaseLib
{
    protected $cn_db;
    protected $table;
    protected $idTable;
    protected $key;
    protected $camposEncrypt;
    
    public function __construct($params=null)
    {
        $this->key="Dgfr.dags+2020DA";
        $CI=&get_instance();
        $this->cn_db=isset($params["conexion"])?$params["conexion"]:$CI->conexion;
        $this->table=$params["table"];
        $this->idTable=$params["idTable"];
    }
    public function guardarArray(&$array)
    {
        if((int)$array[$this->idTable]==0){
            $this->cn_db->insert($this->table,$array);
            $array[$this->idTable]=$this->cn_db->insert_id();
        }else{
            $this->sentenciaUpdate($array, $this->idTable);
        }
    }
    protected function guardarObjeto($objeto)
    {
        if((int)($objeto->__get($this->idTable))==0)
        {
            $this->cn_db->insert($this->table,$objeto);
            $objeto->__set($this->idTable,$this->cn_db->insert_id());
        }else{
            $this->cn_db->where($this->idTable,$objeto->__get($this->idTable));
            $this->cn_db->update($this->table,$objeto);
        }
    }
    public function guardarStdObject($objeto)
    {
    	$idTable=$this->idTable;
    	var_dump($this->table);
        if(intval($objeto->$idTable)==0){
            $this->cn_db->insert($this->table,$objeto);
            $objeto->$idTable=$this->cn_db->insert_id();
        }else{
            $this->cn_db->where($this->idTable,$objeto->$idTable);
            $this->cn_db->update($this->table,$objeto);
        }
    }
    protected function guardarObjectoEncrypt($objeto)
    {
        $assoc=(array)$objeto;
        foreach ($assoc as $k=>$v)
        {
            if(in_array($k, $this->camposEncrypt)){
                //echo $this->db_server->set($k, $this->cadEncrypt($v),FALSE)->get_compiled_insert($this->table);
                $this->cn_db->set($k, $this->cadEncrypt($v),FALSE);
            }else{
                $this->cn_db->set($k,$v);
            }
        }
        if(intval($objeto->__get($this->idTable))==0)
        {
            $this->cn_db->insert($this->table);
            $objeto->__set($this->idTable,$this->cn_db->insert_id());
        }else{
            $this->cn_db->where($this->idTable,$objeto->__get($this->idTable));
            $this->cn_db->update($this->table);
        }
    }
    protected function getObjetoById($idValorTabla,$class)
    {
        $this->cn_db->select("*");
        $this->cn_db->from($this->table);
        $this->cn_db->where($this->idTable,$idValorTabla);
        $res=$this->cn_db->get();
        return current($res->custom_result_object($class));
    }
    protected function getListaObjetos($sql,array $params,$class)
    {
        $query=$this->cn_db->query($sql,$params);
        return $query->custom_result_object($class);
    }
    protected function sentenciaUpdate($array,$idTabla)
    {
        $this->cn_db->where($idTabla,$array[$idTabla]);
        $this->cn_db->update($this->table,$array);
    }
    protected function updateObject($objeto)
    {
        $this->cn_db->where($this->idTable,$objeto->__get($this->idTable));
        $this->cn_db->update($this->table,$objeto);
    }
    function getStdArrayById($valor,$std=false){
        $this->cn_db->select("*");
        $this->cn_db->from($this->table);
        $this->cn_db->where($this->idTable,$valor);
        $res=$this->cn_db->get();
        //return $res->row_array();
        return $std?$res->row():$res->row_array();
    }
    public function getListRowsAssoc($sql,$params=array())
    {
        $res=$this->cn_db->query($sql,$params);
        return $res->result_array();
    }
    public function getStmtDecrypt(array $campos,$otherTable="")
    {
        $res="";
        foreach ($campos as $key => $value) 
        {
            $table=$otherTable!=""?$otherTable:$this->table;
            $res=$res!=null?$res.",":"";
            if(in_array($value, $campos))
            {
                $res.="AES_DECRYPT($table.$value,'{$this->key}') as $value";
                //$res.="AES_DECRYPT($this->table.$value,'{$this->key}') as $value";
                //$res.="AES_DECRYPT(".($otherTable!=''?$otherTable.".".$value:$this->table.$value).",'{$this->key}') as $value";
            }
            else
            {
                $res.="$table.value as $value";
                //$res.="$this->table.value as $value";
                //$res.=".$otherTable!=''?$otherTable.".".$value:$this->table.value as $value";
            }
        }
        return $res;
    }
    public function getDato($sql,$params=array())
    {
        $dato=null;
        $res=$this->cn_db->query($sql,$params);
        $row=$res->row_array();
        
        if(count($row)==1){
            $dato=current($row);
        }else{
            throw new \Exception("Error al consultar dato");
        }
        return $dato;
    }
    public function cadDecrypt($campo)
    {
        return "AES_DECRYPT($campo,'{$this->key}')";
    }
    public function cadEncrypt($campo)
    {
        return "AES_ENCRYPT('$campo','{$this->key}')";
    }
    public function objectToArray($object)
    {
        $ar1=(Array)$object;
        $arreglo=Array();
        $clase=\get_class($object);
        foreach($ar1 as $key=>$val)
        {
            $arreglo[substr(trim($key), strlen($clase) + 1)]=$val;
        }
        return $arreglo;
    }
    function test(){
    	echo "test esta libreria";
    }
}

