<?php
namespace application\models;

class MyModel extends \CI_Model
{
    protected $db_server;
    protected $table;
    protected $idTable;
    protected $key;
    protected $camposEncrypt;
    
    public function __construct()
    {
        parent::__construct();
        $this->key="Dgfr.dags+2020DA";
    }
    public function guardarArray(&$array,$idTabla)
    {
        if((int)$array[$idTabla]==0){
            $this->db_server->insert($this->table,$array);
            $array[$idTabla]=$this->db_server->insert_id();
        }else{
            $this->sentenciaUpdate($array, $idTabla);
        }
    }
    protected function guardarObjeto($objeto)
    {
        if((int)($objeto->__get($this->idTable))==0)
        {
            $this->db_server->insert($this->table,$objeto);
            $objeto->__set($this->idTable,$this->db_server->insert_id());
        }else{
            $this->db_server->where($this->idTable,$objeto->__get($this->idTable));
            $this->db_server->update($this->table,$objeto);
        }
    }
    protected function guardarStdObject($objeto,$idTable)
    {
        //var_dump($objeto->$idTable);
        if(intval($objeto->$idTable)==0){
            $this->db_server->insert($this->table,$objeto);
            $objeto->$idTable=$this->db_server->insert_id();
        }else{
            $this->db_server->where($this->idTable,$objeto->$idTable);
            $this->db_server->update($this->table,$objeto);
        }
    }
    protected function guardarObjectoEncrypt($objeto)
    {
        $assoc=(array)$objeto;
        foreach ($assoc as $k=>$v)
        {
            if(in_array($k, $this->camposEncrypt)){
                //echo $this->db_server->set($k, $this->cadEncrypt($v),FALSE)->get_compiled_insert($this->table);
                $this->db_server->set($k, $this->cadEncrypt($v),FALSE);
            }else{
                $this->db_server->set($k,$v);
            }
        }
        if(intval($objeto->__get($this->idTable))==0)
        {
            $this->db_server->insert($this->table);
            $objeto->__set($this->idTable,$this->db_server->insert_id());
        }else{
            $this->db_server->where($this->idTable,$objeto->__get($this->idTable));
            $this->db_server->update($this->table);
        }
    }
    protected function getObjetoById($idValorTabla,$class)
    {
        $this->db_server->select("*");
        $this->db_server->from($this->table);
        $this->db_server->where($this->idTable,$idValorTabla);
        $res=$this->db_server->get();
        return current($res->custom_result_object($class));
    }
    protected function getListaObjetos($sql,array $params,$class)
    {
        $query=$this->db_server->query($sql,$params);
        return $query->custom_result_object($class);
    }
    protected function sentenciaUpdate($array,$idTabla)
    {
        $this->db_server->where($idTabla,$array[$idTabla]);
        $this->db_server->update($this->table,$array);
    }
    protected function updateObject($objeto)
    {
        $this->db_server->where($this->idTable,$objeto->__get($this->idTable));
        $this->db_server->update($this->table,$objeto);
    }
    protected function getArrayById($idTabla,$valor,$std=false){
        $this->db_server->select("*");
        $this->db_server->from($this->table);
        $this->db_server->where($idTabla,$valor);
        $res=$this->db_server->get();
        //return $res->row_array();
        return $std?$res->row():$res->row_array();
    }
    protected function getListRowsAssoc($sql,$params=array())
    {
        $res=$this->db_server->query($sql,$params);
        return $res->result_array();
    }
    protected function getStmtDecrypt(array $campos,$otherTable="")
    {
        $res="";
        foreach ($campos as $key => $value) 
        {
            $table=$otherTable!=""?$otherTable:$this->table;
            $res=$res!=null?$res.",":"";
            if(in_array($value, $campos))
            {
                $res.="AES_DECRYPT($table.$value,'{$this->key}') as $value";
                //$res.="AES_DECRYPT($this->table.$value,'{$this->key}') as $value";
                //$res.="AES_DECRYPT(".($otherTable!=''?$otherTable.".".$value:$this->table.$value).",'{$this->key}') as $value";
            }
            else
            {
                $res.="$table.value as $value";
                //$res.="$this->table.value as $value";
                //$res.=".$otherTable!=''?$otherTable.".".$value:$this->table.value as $value";
            }
        }
        return $res;
    }
    protected function getDato($sql,$params=array())
    {
        $dato=null;
        $res=$this->db_server->query($sql,$params);
        $row=$res->row_array();
        
        if(count($row)==1){
            $dato=current($row);
        }else{
            throw new \Exception("Error al consultar dato");
        }
        return $dato;
    }
    protected function cadDecrypt($campo)
    {
        return "AES_DECRYPT($campo,'{$this->key}')";
    }
    protected function cadEncrypt($campo)
    {
        return "AES_ENCRYPT('$campo','{$this->key}')";
    }
    protected function objectToArray($object)
    {
        $ar1=(Array)$object;
        $arreglo=Array();
        $clase=\get_class($object);
        foreach($ar1 as $key=>$val)
        {
            $arreglo[substr(trim($key), strlen($clase) + 1)]=$val;
        }
        return $arreglo;
    }
}

