<?php
use application\models\hclinica\TestModel;

//use application\models\hclinica\CitaModel;
//use application\models\hclinica\CitaModel;
//use application\models\hclinica\models\CitaModel;

//namespace application\controllers\clinica;

class CitaC extends CI_Controller
{
    public $conexion;
    //public $CitaModel;
    
    public function __construct()
    {
        //new CitaModel()
        parent::__construct();
        $this->load->helper("url");
        $this->load->helper("form");
        $this->load->library('Form_validation');
        $this->load->library("parser");
        $this->load->library("session");
        
        $this->conexion=$this->load->database("hclinica",true);
        //$this->load->model("hclinica/models/CitaModel");
        //$this->CitaModel=$this->CitaModel->model();
        //CI_Controller::get_instance();
        //$this->citaModel=new CitaModel();
        $this->load->model("hclinica/CitaModel","citaModel");
        
        $this->testModel=new TestModel();
    }
    public function index()
    {
        $this->citaModel->guardar("objeto",1);
    }
    public function formCita($id=null)
    {
        $data=$this->init();
        if($id!=null)
        {
            $data=$this->citaModel->getCitaById($id);
            $time=strtotime($data["fechaAtencion"]);
            $data["minuto"]=date("i",$time);
            if($data==null){
                show_404();
            }
            //$time=strtotime($data["fechaAtencion"]);
            $data["fecha"]=date("d-m-Y",$time);
            $data["hora"]=date("H",$time);
        }
        $this->load->view("hclinica/form/cita/formCita",$data);
    }
    public function listCita()
    {
        $this->load->view("hclinica/lista/cita/listCita");
    }
    public function guardarCita()
    {
        $res=array("res"=>false,"message"=>"Error al guardar");
        if($this->input->server("REQUEST_METHOD")=="POST"){
            $data=array(
                "fechaAtencion"=>date("Y-m-d",strtotime($this->input->post("fecha")))." ".$this->input->post("hora").":".$this->input->post("minuto").":00",
                "idCita"=>$this->input->post("idCita"),
                "fechaAlta"=>date("Y-m-d H:i:s"),
                "idPaciente"=>1,
                "asunto"=>$this->input->post("asunto"),
                "comentarios"=>$this->input->post("comentarios"),
                "situacion"=>"PENDIENTE",
                "status"=>1
            );
            $this->citaModel->guardarArray($data,"idCita");
            $res["res"]=true;
            $res["message"]="Cambios guardados";
        }
        echo json_encode($res);
    }
    public function getAllCitas()
    {
        $res=array("res"=>false,"message"=>"","citas"=>array());
        
        if($this->input->is_ajax_request())
        {
            $this->conexion->select('*');
            $this->conexion->from('cita');
            $query = $this->conexion->get();
            $row = $query->result_array();
            $res["citas"]=$row;
            $res["res"]=true;
        }
        echo json_encode($res);
    }
    public function cancelarCita()
    {
        $res=array("res"=>false,"message"=>"Error al guardar cita");
        
        if($this->input->server("REQUEST_METHOD")=="POST"){
            $cita=$this->citaModel->getCitaById($this->input->post("idCita"));
            
            if($cita!=null){
                $cita["situacion"]="CANCELADO";
                $this->citaModel->guardarCita($cita);
                $res["res"]=true;
                $res["message"]="Cambios guardados";
            }
        }
        echo json_encode($res);
    }
    private function init()
    {
        $data=array(
            "idCita"=>0,
            "idPaciente"=>0,
            "asunto"=>"",
            "comentarios"=>"",
            "fecha"=>date("d-m-Y"),
            "hora" => date("H"),
            "minuto" => date("i"),
            "fechaAlta"=>date("Y-m-d H:i:s"),
            "situacion"=>"PENDIENTE",
            "status"=>0
        );
        return $data;
    }
}

