<?php
use application\entities\hclinica\UsuarioEnt;
use application\models\hclinica\tables\Persona;

//use application\entities\hclinica\Usuario;

//namespace proyectos\application\controllers\clinica;

class Usuario extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $helpers=array("url","form");
        $libraries=array("session","parser");
        $this->load->helper($helpers);
        $this->load->library($libraries);
        
        $this->conexion=$this->load->database("hclinica",true);
        $this->load->model("hclinica/UsuarioModel","usuarioModel");
        $this->load->model("hclinica/models/PersonaModel","personaModel");
        //$this->usuarioModel=new UsuarioModel();
    }
    public function listUsuario()
    {
        $this->load->view("hclinica/lista/usuario/listUsuario");
    }
    public function guardarUsuario()
    {
        $res=Array("res"=>false,"message"=>"Usuario no guardado");
        if($this->input->server("REQUEST_METHOD")=="POST")
        {   //buscar por login y persona tipo usuario
            $post=$this->input->post();
            $persona=new Persona();
            $persona->__set("tipo", "USUARIO");
            $usuario=new UsuarioEnt($post);
            $this->personaModel->guardarPersona($persona);
            $usuario->__set("idPersona", $persona->idPersona);
            $this->usuarioModel->guardarUsuario($usuario);
            $res["message"]="Usuario guardado";
            $res["usuario"]=(array)$usuario;
            $res["res"]=true;
        }
        echo json_encode($res);
    }
    public function getListUsuario() 
    {
        $res=array("res"=>false,"message"=>"","datos"=>array());
        
        if($this->input->is_ajax_request())
        {
            $list=$this->usuarioModel->getListUsuario();
            $res["datos"]=$list;
            $res["res"]=true;
        }
        echo json_encode($res);
    }
}

