<?php
namespace application\models;

class MainModel
{
    private $driver;
    private $tabla;
    
    public function __construct(\CI_DB_mysqli_driver $driver, $tabla)
    {
        $this->driver=$driver;
        $this->tabla=$tabla;
    }
    public function guardar($objeto,$id)
    {
        if((int)$objeto->__get($id)==0){
            $this->driver->insert($this->tabla,$objeto);
            $objeto->__set($id,$this->driver->insert_id());
        }else{
            $this->sentenciaUpdate($objeto, $id);
        }
        //$this->driver->insert($this->tabla,$obj);
        //return $this->driver->insert_id();
    }
    private function sentenciaUpdate($objeto,$id)
    {
        $this->driver->where($id,$objeto->__get($id));
        $this->driver->update($this->tabla,$objeto);
    }
    public function consultar()
    {
        $this->driver->select('*');
        $this->driver->from($this->tabla);
        $consulta = $this->driver->get();
        $resultado = $consulta->result_array();
        return $resultado;
    }
    public function consultarPorId($id,$valor){
        $this->driver->select("*");
        $this->driver->from($this->tabla);
        $this->driver->where($id,$valor);
        $res=$this->driver->get();
        return $res->row_array();
    }
    public function getResultArray($sql){
        $stmt=$this->driver->query($sql);
        return $stmt->result_array();
    }
    public function trans_begin(){
        $this->driver->trans_begin();
    }
    public function trans_commit($param) {
        $this->driver->trans_commit();
    }
    public function trans_rollback($param) {
        $this->driver->trans_rollback();
    }
    public static function cast(\CI_DB_mysqli_driver $driver){
        return $driver;
    }
}

